//: ## ![3DaysOfSwift.com Logo](3DaysIcon46.png) Declaring Functions
//:
//: * Use the `func` keyword to declare a function.
//:
//: * Write a unique name for the function. The name will act as the unique address to identify that specific function.
//:
//: * Input parameters have a label, variable name and type annotation.
//:
//: * A return type must be declared in order to return a value.
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:



func functionName(label variable1Name: Int, label2 variable2Name: Int) -> Int {
    return 100
}

func functionName(label variable1Name: Double, label2 variable2Name: Double) -> Double {
    return 100.0
}

func functionName(label variable1Name: Bool, label2 variable2Name: Bool) -> Bool {
    return true
}

func functionName(label variable1Name: String, label2 variable2Name: String) -> String {
    return "100.0"
}
functionName(label: <#T##String#>, label2: <#T##String#>)


//:
//: -------------------
//:
//: ## Task:
//:
//: Execute one of the functions above. Do you notice how you must write the label names when passing in an input parameter?
//:
//: Execute the function below. Do you notice how we now omit the labels?
//:
//: Remove the underscores and resolve the compilation error generated by Xcode.
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:


func functionName(_ variable1Name: String, _ variable2Name: String) -> String {
    return "100.0"
}
functionName(<#T##variable1Name: String##String#>, <#T##variable2Name: String##String#>)


//:
//: -------------------
//:
//: * callout(💡 Tip):
//:     → Each function above contains only 1 line of code.
//:
//:     Go back and remove the `return` keyword from the functions declared above. Swift provides this option for one-line branches of code.
//:
//: -------------------
//:


func getHappyFace() -> String {
    return ["🙂", "😀", "😄", "😊", "😃", "🤓", "😇"].randomElement() ?? "🙂" // what does the nil coalescing operator do?
}

func get3HappyFaces() -> String {
    return getHappyFace() + getHappyFace() + getHappyFace()
}

func printHappyFaces() {
    let threeHappyFaces = get3HappyFaces()
    print(threeHappyFaces)
}


//:
//: -------------------
//:
//: ## Task:
//:
//: In the code area below, declare a function to print a random character from the english alphabet.
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:


// write code here


//:
//: -------------------
//:
//: ## Task:
//:
//: In the code area below, overload the same global function to accept the alphabet as an input paramenter with a label.
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:


// write code here


//:
//: -------------------
//:
//: ## Task:
//:
//: In the code area below, overload the same global function but remove the label from the input paramenter.
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:


// write code here


//:
//: -------------------
//:
//: ## Task:
//:
//: In the code area below, declare a new struct to encapsulate a function which will accept an array of integers and calculate the average value.
//:
//: Print the result to the console.
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:
//: * callout(💡 Tip):
//:     → The average value can be calculated by adding up all values and dividing by the number of values.
//:
//: -------------------
//:


// write code here
// let average = (value1 + value2 + value3) / 3
// let average2 = (value1 + value2 + value3 + value4) / 4
// let average3 = (value1 + value2 + value3 + value4 + value5) / 5





Int.max


//: ## Declaring Functions
//: 👨🏻‍🏫 Lesson | [Watch Online Video](https://www.google.com)
//:
/*:
 
 */
//:
//:
//: -------------------
//:

func printHappyFaces() {
    print("🙂")
    print("😀")
    print("😃")
}
// 🔵 Run Point

//:
//: To execute this function we must write its name followed by brackets `()`.
//:
//: Execute the run point below. The code within the function will execute once.
//:
//: -------------------
//:

printHappyFaces()
// 🔵 Run Point

//:
//: We can execute the code contained in this function as many times as we need.
//:
//: Execute the run point below. The function is called 4 times. The code within the function will execute 4 times.
//:
//: -------------------
//:

printHappyFaces()
printHappyFaces()
printHappyFaces()
printHappyFaces()
// 🔵 Run Point

//:
//: Functions can be confined within a `Type`.
//:
//: This is a common use of functions as it creates architecture and a well defined scope to operate in.
//:
//: The code below executes a function within the `Int` type named `random`. This function accepts a numerical range as input and produces one of these values selected at random.
//:
//: -------------------
//:

let diceRoll = Int.random(in: 1...6)
print(diceRoll == 6 ? "You win!" : "You lose.")
// 🔵 Run Point

//:
//: We'll discuss nested functions in the following lesson.
//:
//:
//: -------------------
//:
//: [◀  Previous Page](@previous)  |  [Next Page  ▶](@next)
//:
//: -------------------
//: ![SwiftSimplified.com - We teach Swift](swift-simplified-logo.png) [SwiftSimplified.com](https://www.swiftsimplified.com) | [30 Days of Swift](https://www.swiftsimplified.com/30-days-of-swift)
/*:
 
 */
//:
//: -------------------
